package com.qboxus.tictic.activitesfragments

import android.app.Activity
import android.content.Context
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.inputmethod.InputMethodManager
import androidx.databinding.DataBindingUtil
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.databinding.FragmentEditTextSheetBinding
import com.qboxus.tictic.interfaces.FragmentCallBack
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import com.google.android.material.bottomsheet.BottomSheetDialogFragment

class EditTextSheetFragment : BottomSheetDialogFragment, View.OnClickListener {
    lateinit var binding: FragmentEditTextSheetBinding
    var callBack: FragmentCallBack? = null
    var commentType: String? = null
    var tagedUser = ArrayList<UserModel>()

    constructor(
        commentType: String?,
        tagedUser: ArrayList<UserModel>,
        callBack: FragmentCallBack?
    ) {
        this.callBack = callBack
        this.tagedUser = tagedUser
        this.commentType = commentType
    }

    constructor()

    override fun onDetach() {
        hideKeyboard()
        super.onDetach()
    }

    private fun hideKeyboard() {
        binding.messageEdit.clearFocus()
        val imm = requireActivity().getSystemService(Activity.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.hideSoftInputFromWindow(binding.messageEdit.windowToken, 0)
    }


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {

        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_edit_text_sheet, container, false)

        initControl()
        actionControl()
        return binding.getRoot()
    }

    override fun onStart() {
        super.onStart()
        showKeyboard()
    }
    private fun actionControl() {
        binding.messageEdit.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {}
            override fun onTextChanged(charSequence: CharSequence, i: Int, i1: Int, count: Int) {
                val message = binding.messageEdit.text.toString()
                if (message.length > 0) {
                    val lastChar = charSequence.toString().substring(charSequence.length - 1)
                    if (lastChar == "@") {
                        binding.tabTagFriends.visibility = View.GONE
                        openFriends()
                    } else {
                        binding.tabTagFriends.visibility = View.VISIBLE
                    }
                }
            }

            override fun afterTextChanged(editable: Editable) {}
        })
        binding.tabTagFriends.setOnClickListener {
            var message = binding.messageEdit.text.toString()
            message = "$message@"
            binding.messageEdit.setText("" + message)
            binding.messageEdit.setSelection(binding.messageEdit.text!!.length)
        }
    }

    private fun checkUserExistInList(tagUser: String): Boolean {
        var isExist = false
        for (user in tagedUser) {
            if (user.username == "" + tagUser) {
                isExist = true
            }
        }
        return isExist
    }

    private fun removeUserExistInList(tagUser: String) {
        for (user in tagedUser) {
            if (user.username == "" + tagUser) {
                tagedUser.removeAt(tagedUser.indexOf(user))
            }
        }
    }

    private fun openFriends() {
        val fragment = CommentTagedFriendsFragment(
            Functions.getSharedPreference(
                binding.root.context
            ).getString(Variables.U_ID, "")
        ) { bundle ->
            if (bundle.getBoolean("isShow", false)) {
                val arrayList = bundle.getSerializable("data") as ArrayList<UserModel>?
                for (i in arrayList!!.indices) {
                    val item = arrayList[i]
                    tagedUser.add(item)
                    var lastChar: String? = null
                    if (!TextUtils.isEmpty(binding.messageEdit.text.toString())) lastChar =
                        binding.messageEdit.text.toString().substring(
                            binding.messageEdit.text!!.length - 1
                        )
                    if (lastChar != null && lastChar.contains("@")) binding.messageEdit.setText(
                        binding.messageEdit.text.toString() + item.username + " "
                    ) else binding.messageEdit.setText(
                        binding.messageEdit.text.toString() + "@" + item.username + " "
                    )
                    binding.messageEdit.setSelection(binding.messageEdit.text!!.length)
                }
            }
        }
        fragment.show(requireActivity().supportFragmentManager, "CommentTagedFriendsF")
    }

    private fun initControl() {
        if (commentType == "OwnComment") {
            binding.messageEdit.hint = binding.root.context.getString(R.string.leave_a_comment)
        } else if (commentType == "replyComment") {
            binding.messageEdit.hint = "" + requireArguments().getString("replyStr")
        }
        binding.sendBtn.setOnClickListener(this)
        binding.messageEdit.setOnClickListener(this)

    }

    private fun showKeyboard() {
        Handler(Looper.getMainLooper()).postDelayed({
            binding.messageEdit.requestFocus()
            val imm = requireActivity().getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
            imm.showSoftInput(binding.messageEdit, 0)
        }, 200)
    }


    private fun openKeyboard(view: View) {
        // Create a dummy view
        val dummyView = View(requireContext())
        dummyView.layoutParams = ViewGroup.LayoutParams(0, 0)

        // Add the dummy view to the fragment's root layout
        (view as ViewGroup).addView(dummyView)

        // Request focus on the dummy view
        dummyView.requestFocus()

        // Get the InputMethodManager
        val imm = requireContext().getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager

        // Show the keyboard
        imm.toggleSoftInput(InputMethodManager.SHOW_FORCED, InputMethodManager.HIDE_IMPLICIT_ONLY)
    }


    override fun onClick(view: View) {
        when (view.id) {
            R.id.send_btn -> {
                if (binding.messageEdit.text.toString().length > 0) {
                    val bundle = Bundle()
                    bundle.putBoolean("isShow", true)
                    bundle.putString("action", "sendComment")
                    bundle.putString("message", "${binding.messageEdit.text.toString()}")
                    bundle.putSerializable("taggedUserList", tagedUser)
                    callBack?.onResponce(bundle)
                    dismiss()
                }
            }

            R.id.message_edit -> {
                view.clearFocus()
                view.requestFocus()
                Log.d(Constants.tag, "Focus True")
            }
        }
    }
}